/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api.uddi;

import filenet.vw.base.logging.Logger;
import filenet.ws.api.uddi.WSUDDIRegistry;
import java.util.Locale;
import java.util.Vector;

public class WSUDDI {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    private static String m_className = "WSUDDI";
    private static String m_language = Locale.getDefault().getLanguage();
    private Vector m_UDDIRegistries = new Vector();

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:04:00  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.3  $";
    }

    public void releaseReferences() {
        block4: {
            try {
                m_language = null;
                if (this.m_UDDIRegistries != null) {
                    Object obj = null;
                    for (int i = this.m_UDDIRegistries.size() - 1; i >= 0; --i) {
                        obj = this.m_UDDIRegistries.remove(i);
                        if (obj == null || !(obj instanceof WSUDDIRegistry)) continue;
                        ((WSUDDIRegistry)obj).releaseReferences();
                        obj = null;
                    }
                }
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block4;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    static boolean isSameLanguage(String language) {
        if (m_language != null && language != null) {
            return m_language.compareTo(language) == 0;
        }
        return false;
    }

    public void addUDDIRegistry(WSUDDIRegistry uddiRegistry) {
        if (uddiRegistry != null) {
            this.m_UDDIRegistries.add(uddiRegistry);
        }
    }

    public WSUDDIRegistry[] getUDDIPublishingRegistries() {
        if (this.m_UDDIRegistries != null && this.m_UDDIRegistries.size() > 0) {
            Vector v = new Vector();
            Object obj = null;
            for (int i = 0; i < this.m_UDDIRegistries.size(); ++i) {
                obj = this.m_UDDIRegistries.get(i);
                if (obj == null || !(obj instanceof WSUDDIRegistry) || !((WSUDDIRegistry)obj).isPublishingEnabled()) continue;
                v.add(obj);
            }
            if (v.size() > 0) {
                WSUDDIRegistry[] uddiRegistries = new WSUDDIRegistry[v.size()];
                v.toArray(uddiRegistries);
                v.clear();
                return uddiRegistries;
            }
        }
        return null;
    }

    public WSUDDIRegistry[] getUDDIRegistries() {
        if (this.m_UDDIRegistries != null && this.m_UDDIRegistries.size() > 0) {
            WSUDDIRegistry[] uddiRegistries = new WSUDDIRegistry[this.m_UDDIRegistries.size()];
            this.m_UDDIRegistries.toArray(uddiRegistries);
            return uddiRegistries;
        }
        return null;
    }

    public WSUDDIRegistry getUDDIRegistry(String name) {
        if (name != null) {
            Object obj = null;
            WSUDDIRegistry uddiRegistry = null;
            String aName = null;
            for (int i = 0; i < this.m_UDDIRegistries.size(); ++i) {
                obj = this.m_UDDIRegistries.get(i);
                if (obj == null || !(obj instanceof WSUDDIRegistry) || (aName = (uddiRegistry = (WSUDDIRegistry)obj).getName()) == null || aName.compareTo(name) != 0) continue;
                return uddiRegistry;
            }
        }
        return null;
    }
}

